/* 855wrap - a hack to prevent lockup of XFree86 on certain notebooks */

/* usage: 855wrap */

/* This source code is in the public domain. Please mention me, if you use */
/* this code in your work. */
/* This is a dirty hack, so don't blame me  */
/* if something bad happens. */

/* Christian Zietz <czietz@gmx.net> */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/io.h>
#include <sys/mman.h>
#define __USE_GNU
#include <string.h>

// these are defined in wrapper.o
extern unsigned char _binary_wrapper_bin_start[];
extern unsigned int _binary_wrapper_bin_size;

// macros for easier access
#define wrapper(x) _binary_wrapper_bin_start[x]
#define inttbl(x,y) *((unsigned char *)((x<<2)+y))
#define wrappersize ((unsigned int)&_binary_wrapper_bin_size)

#define vbiosaddr 0xc0000
#define vbiossize 0x10000
#define chipsetid 0x35808086

// wrapper.asm specific
#define wrapperentry 9
#define wrapperjmp 5

int main (int argc, char *argv[]) {

  int i;
  int memfd = 0;
  int oldpam;
  unsigned char *memptr;
  unsigned char *wrapperptr;

  // give me permission to access io ports
  if (iopl(3)<0) {
    fprintf(stderr, "Could not set IO permissions!\n%s must be run as root\n", argv[0]);
    return 1;
  }

  // check for correct chipset
  outl(0x80000000, 0xcf8);
  if (inl(0xcfc) != chipsetid) {
    fprintf(stderr, "No i855GM chipset found!\n");
    return 1;
  }
  printf("i855GM chipset found\n");

  // open /dev/mem and mmap memory
  memfd = open("/dev/mem", O_RDWR);
  if (memfd == -1) {
    fprintf(stderr, "Could not open /dev/mem!\n");
    return 1;
  }

  memptr = mmap((char *)0, vbiosaddr+vbiossize, PROT_READ | PROT_WRITE, MAP_SHARED | MAP_FIXED, memfd, 0);
  if (memptr == (unsigned char *)-1) {
    fprintf(stderr, "Could not mmap /dev/mem!\n");
    close(memfd);
    return 1;
  }

  // check int10 hook to see if 855wrap was already run before
  wrapperptr = (unsigned char*)(inttbl(0x10,3)<<12)+(inttbl(0x10,2)<<4)+
    (inttbl(0x10,1)<<8)+(inttbl(0x10,0))-wrapperentry;

  if (*(unsigned long*)wrapperptr == 0xdeadbeef) {
    fprintf(stderr, "855wrap was already run before!\n");
    munmap(memptr, vbiosaddr+vbiossize);
    close(memfd);
    return 1;
  }

  // save old int10 hook
  for (i=0; i<4; i++) {
    wrapper(wrapperjmp+i) = inttbl(0x10, i);
  }

  // set permissions to read and write so I can write into shadowed VideoBIOS
  outl(0x80000058, 0xcf8);
  oldpam = inw(0xcfe);
  outl(0x80000058, 0xcf8);
  outw(0x3333, 0xcfe);

  // copy wrapper to real mode memory at the end of the VBIOS
  wrapperptr = (char *)((vbiosaddr+vbiossize-wrappersize-1) & 0xffff0);
  memcpy(wrapperptr, &(wrapper(0)), wrappersize);

  // reset permissions
  outl(0x80000058, 0xcf8);
  outw(oldpam, 0xcfe);

  // set new int10 hook to wrapper
  inttbl(0x10, 0) = (unsigned int)(wrapperptr+wrapperentry) & 0xf;
  inttbl(0x10, 1) = 0;
  inttbl(0x10, 2) = ((unsigned int)(wrapperptr+wrapperentry) >> 4) & 0xff;
  inttbl(0x10, 3) = ((unsigned int)(wrapperptr+wrapperentry) >> 12) & 0xff;

  munmap(memptr, vbiosaddr+vbiossize);
  close(memfd);

  printf("Successfully installed wrapper!\n");
  return 0;
}
